/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.heapdump;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Path;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class HeapDump
extends Enum<HeapDump> {
    private static final String DIAGNOSTIC_BEAN = "com.sun.management:type=HotSpotDiagnostic";
    private static final /* synthetic */ HeapDump[] $VALUES;

    public static HeapDump[] values() {
        return (HeapDump[])$VALUES.clone();
    }

    public static HeapDump valueOf(String name) {
        return Enum.valueOf(HeapDump.class, name);
    }

    public static void dumpHeap(Path outputPath, boolean live) throws Exception {
        String outputPathString = outputPath.toAbsolutePath().normalize().toString();
        if (HeapDump.isOpenJ9()) {
            HeapDump.dumpOpenJ9(outputPathString);
        } else {
            HeapDump.dumpHotspot(outputPathString, live);
        }
    }

    private static void dumpOpenJ9(String outputPathString) throws Exception {
        Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
        Method heapDumpMethod = dumpClass.getMethod("heapDumpToFile", String.class);
        heapDumpMethod.invoke(null, outputPathString);
    }

    private static void dumpHotspot(String outputPathString, boolean live) throws Exception {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName diagnosticBeanName = ObjectName.getInstance(DIAGNOSTIC_BEAN);
        HotSpotDiagnosticMXBean proxy = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, HotSpotDiagnosticMXBean.class);
        proxy.dumpHeap(outputPathString, live);
    }

    public static boolean isOpenJ9() {
        try {
            Class.forName("com.ibm.jvm.Dump");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static /* synthetic */ HeapDump[] $values() {
        return new HeapDump[0];
    }

    static {
        $VALUES = HeapDump.$values();
    }

    public static interface HotSpotDiagnosticMXBean {
        public void dumpHeap(String var1, boolean var2) throws IOException;
    }
}

