/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import com.google.common.base.Preconditions;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class NotePlayEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private Instrument instrument;
    private Note note;
    private boolean cancelled;

    @ApiStatus.Internal
    public NotePlayEvent(@NotNull Block block, @NotNull Instrument instrument, @NotNull Note note) {
        super(block);
        this.instrument = instrument;
        this.note = note;
    }

    @NotNull
    public Instrument getInstrument() {
        return this.instrument;
    }

    @NotNull
    public Note getNote() {
        return this.note;
    }

    public void setInstrument(@NotNull Instrument instrument) {
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"instrument cannot be null");
        this.instrument = instrument;
    }

    public void setNote(@NotNull Note note) {
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"note cannot be null");
        this.note = note;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

