/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.field;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.builder.matcher.FieldMatcher;
import io.papermc.asm.rules.field.FieldRewriteRule;
import io.papermc.asm.rules.field.FilteredFieldRewriteRule;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FieldRewrites {
    private static final ClassDesc VOID = Void.TYPE.describeConstable().orElseThrow();

    private FieldRewrites() {
    }

    public record ToMethodSameOwner(Set<ClassDesc> owners, FieldMatcher fieldMatcher, @Nullable String getterName, @Nullable String setterName, boolean isInterfaceMethod) implements FilteredFieldRewriteRule
    {
        public ToMethodSameOwner(Set<ClassDesc> owners, FieldMatcher fieldMatcher, @Nullable String getterName, @Nullable String setterName, boolean isInterfaceMethod) {
            if (getterName == null && setterName == null) {
                throw new IllegalArgumentException("At least one of getterName or setterName must be non-null");
            }
        }

        @Override
        public FieldRewriteRule.Rewrite rewrite(ClassProcessingContext context, int opcode, String owner, String name, ClassDesc fieldTypeDesc) {
            return delegate -> {
                String methodName;
                Type type = switch (opcode) {
                    case 178, 180 -> Type.GETTER;
                    case 179, 181 -> Type.SETTER;
                    default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
                };
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case GETTER: {
                        String string = this.getterName;
                        break;
                    }
                    case SETTER: {
                        String string = methodName = this.setterName;
                    }
                }
                if (methodName == null) {
                    return;
                }
                delegate.visitMethodInsn(type.opcode(opcode), owner, methodName, type.desc(fieldTypeDesc).descriptorString(), this.isInterfaceMethod);
            };
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static enum Type {
            GETTER{

                @Override
                int opcode(int fieldOpcode) {
                    return switch (fieldOpcode) {
                        case 180 -> 182;
                        case 178 -> 184;
                        default -> throw new IllegalArgumentException("Unexpected opcode: " + fieldOpcode);
                    };
                }

                @Override
                MethodTypeDesc desc(ClassDesc fieldTypeDesc) {
                    return MethodTypeDesc.of(fieldTypeDesc, new ClassDesc[0]);
                }
            }
            ,
            SETTER{

                @Override
                int opcode(int fieldOpcode) {
                    return switch (fieldOpcode) {
                        case 181 -> 182;
                        case 179 -> 184;
                        default -> throw new IllegalArgumentException("Unexpected opcode: " + fieldOpcode);
                    };
                }

                @Override
                MethodTypeDesc desc(ClassDesc fieldTypeDesc) {
                    return MethodTypeDesc.of(VOID, fieldTypeDesc);
                }
            };


            abstract int opcode(int var1);

            abstract MethodTypeDesc desc(ClassDesc var1);
        }
    }
}

