/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.collection;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Validate;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class MultiThreadedQueue<E>
implements Queue<E> {
    protected volatile LinkedNode<E> head;
    protected volatile LinkedNode<E> tail;
    protected static final VarHandle HEAD_HANDLE = ConcurrentUtil.getVarHandle(MultiThreadedQueue.class, "head", LinkedNode.class);
    protected static final VarHandle TAIL_HANDLE = ConcurrentUtil.getVarHandle(MultiThreadedQueue.class, "tail", LinkedNode.class);

    protected final void setHeadPlain(LinkedNode<E> newHead) {
        HEAD_HANDLE.set(this, newHead);
    }

    protected final void setHeadOpaque(LinkedNode<E> newHead) {
        HEAD_HANDLE.setOpaque(this, newHead);
    }

    protected final LinkedNode<E> getHeadPlain() {
        return HEAD_HANDLE.get(this);
    }

    protected final LinkedNode<E> getHeadOpaque() {
        return HEAD_HANDLE.getOpaque(this);
    }

    protected final LinkedNode<E> getHeadAcquire() {
        return HEAD_HANDLE.getAcquire(this);
    }

    protected final void setTailPlain(LinkedNode<E> newTail) {
        TAIL_HANDLE.set(this, newTail);
    }

    protected final void setTailOpaque(LinkedNode<E> newTail) {
        TAIL_HANDLE.setOpaque(this, newTail);
    }

    protected final LinkedNode<E> getTailPlain() {
        return TAIL_HANDLE.get(this);
    }

    protected final LinkedNode<E> getTailOpaque() {
        return TAIL_HANDLE.getOpaque(this);
    }

    public MultiThreadedQueue() {
        LinkedNode value = new LinkedNode(null, null);
        this.setHeadPlain(value);
        this.setTailPlain(value);
    }

    public MultiThreadedQueue(Iterable<? extends E> collection) {
        LinkedNode head;
        Iterator<E> elements = collection.iterator();
        if (!elements.hasNext()) {
            LinkedNode value = new LinkedNode(null, null);
            this.setHeadPlain(value);
            this.setTailPlain(value);
            return;
        }
        LinkedNode tail = head = new LinkedNode(Validate.notNull(elements.next(), "Null element"), null);
        while (elements.hasNext()) {
            LinkedNode next = new LinkedNode(Validate.notNull(elements.next(), "Null element"), null);
            tail.setNextPlain(next);
            tail = next;
        }
        this.setHeadPlain(head);
        this.setTailPlain(tail);
    }

    @Override
    public E remove() throws NoSuchElementException {
        E ret = this.poll();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean add(E element) {
        return this.offer(element);
    }

    public boolean forceAdd(E element) {
        LinkedNode node = new LinkedNode(element, null);
        return !this.forceAppendList(node, node);
    }

    @Override
    public E element() throws NoSuchElementException {
        E ret = this.peek();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean offer(E element) {
        Validate.notNull(element, "Null element");
        LinkedNode node = new LinkedNode(element, null);
        return this.appendList(node, node);
    }

    @Override
    public E peek() {
        LinkedNode<E> head;
        LinkedNode<E> curr = head = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                if (this.getHeadOpaque() == head && curr != head) {
                    this.setHeadOpaque(curr);
                }
                return element;
            }
            if (next == null || curr == next) {
                return null;
            }
            curr = next;
        }
    }

    @Override
    public E poll() {
        return this.removeHead();
    }

    public E pollIf(Predicate<E> predicate) {
        return this.removeHead(Validate.notNull(predicate, "Null predicate"));
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    public boolean preventAdds() {
        LinkedNode deadEnd = new LinkedNode(null, null);
        deadEnd.setNextPlain(deadEnd);
        if (!this.appendList(deadEnd, deadEnd)) {
            return false;
        }
        this.setTailPlain(deadEnd);
        return true;
    }

    public void allowAdds() {
        LinkedNode tail = this.getTailPlain();
        while (tail != (tail = tail.getNextPlain())) {
        }
        tail.setNextVolatile(null);
    }

    public boolean tryAllowAdds() {
        LinkedNode<E> tail = this.getTailPlain();
        int failures = 0;
        while (true) {
            if (tail != (tail = tail.getNextAcquire())) {
                if (tail != null) continue;
                return false;
            }
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (tail == (tail = tail.compareExchangeNextVolatile(tail, null))) {
                return true;
            }
            if (tail == null) {
                return false;
            }
            ++failures;
        }
    }

    public boolean addOrAllowAdds(E element) {
        LinkedNode<E> currTail;
        Validate.notNull(element, "Null element");
        int failures = 0;
        LinkedNode append = new LinkedNode(element, null);
        LinkedNode<E> curr = currTail = this.getTailOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (next == null) {
                LinkedNode<E> compared = curr.compareExchangeNextVolatile(null, append);
                if (compared == null) {
                    if (this.getTailOpaque() == currTail) {
                        this.setTailOpaque(append);
                    }
                    return false;
                }
                ++failures;
                curr = compared;
                continue;
            }
            if (next == curr) {
                LinkedNode<E> compared = curr.compareExchangeNextVolatile(curr, null);
                if (compared == curr) {
                    return true;
                }
                ++failures;
                if (compared == null) continue;
                curr = compared;
                continue;
            }
            if (curr == currTail) {
                curr = next;
                continue;
            }
            if (currTail == (currTail = this.getTailOpaque())) {
                curr = next;
                continue;
            }
            curr = currTail;
        }
    }

    public boolean isAddBlocked() {
        LinkedNode<E> tail = this.getTailOpaque();
        LinkedNode<E> next;
        while ((next = tail.getNextVolatile()) != null) {
            if (next == tail) {
                return true;
            }
            tail = next;
        }
        return false;
    }

    public E pollOrBlockAdds() {
        LinkedNode head;
        int failures = 0;
        LinkedNode curr = head = this.getHeadOpaque();
        while (true) {
            E currentVal = curr.getElementVolatile();
            LinkedNode<E> next = curr.getNextOpaque();
            if (next == curr) {
                return null;
            }
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (currentVal != null) {
                if (curr.getAndSetElementVolatile(null) == null) {
                    ++failures;
                    continue;
                }
                if (this.getHeadOpaque() == head) {
                    this.setHeadOpaque(next != null ? next : curr);
                }
                return currentVal;
            }
            if (next == null) {
                LinkedNode<E> compared;
                if (curr != head && this.getHeadOpaque() == head) {
                    this.setHeadOpaque(curr);
                }
                if ((compared = curr.compareExchangeNextVolatile(null, curr)) != null) {
                    curr = compared;
                    ++failures;
                    continue;
                }
                return null;
            }
            if (head == curr) {
                curr = next;
                continue;
            }
            if (head == (head = this.getHeadOpaque())) {
                curr = next;
                continue;
            }
            curr = head;
        }
    }

    @Override
    public boolean remove(Object object) {
        Validate.notNull(object, "Null object to remove");
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null && (element == object || element.equals(object)) && curr.getAndSetElementVolatile(null) == element) {
                return true;
            }
            if (next == curr || next == null) break;
            curr = next;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Validate.notNull(filter, "Null filter");
        boolean ret = false;
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret |= filter.test(element) && curr.getAndSetElementVolatile(null) == element;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Validate.notNull(collection, "Null collection");
        boolean ret = false;
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret |= collection.contains(element) && curr.getAndSetElementVolatile(null) == element;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Validate.notNull(collection, "Null collection");
        boolean ret = false;
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret |= !collection.contains(element) && curr.getAndSetElementVolatile(null) == element;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> ret = new ArrayList<E>();
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret.add(element);
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        ArrayList<E> ret = new ArrayList<E>();
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret.add(element);
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret.toArray(array);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        Validate.notNull(generator, "Null generator");
        ArrayList<E> ret = new ArrayList<E>();
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ret.add(element);
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return ret.toArray(generator);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultiThreadedQueue: {elements: {");
        int deadEntries = 0;
        int totalEntries = 0;
        int aliveEntries = 0;
        boolean addLocked = false;
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element == null) {
                ++deadEntries;
            } else {
                ++aliveEntries;
            }
            if (totalEntries != 0) {
                builder.append(", ");
            }
            builder.append(totalEntries).append(": \"").append(element).append('\"');
            if (next == null) break;
            if (curr == next) {
                addLocked = true;
                break;
            }
            curr = next;
            ++totalEntries;
        }
        builder.append("}, total_entries: \"").append(totalEntries).append("\", alive_entries: \"").append(aliveEntries).append("\", dead_entries:").append(deadEntries).append("\", add_locked: \"").append(addLocked).append("\"}");
        return builder.toString();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll((Iterable<? extends E>)collection);
    }

    @Override
    public boolean addAll(Iterable<? extends E> iterable) {
        LinkedNode head;
        Validate.notNull(iterable, "Null iterable");
        Iterator<E> elements = iterable.iterator();
        if (!elements.hasNext()) {
            return false;
        }
        LinkedNode tail = head = new LinkedNode(Validate.notNull(elements.next(), "Null element"), null);
        while (elements.hasNext()) {
            LinkedNode next = new LinkedNode(Validate.notNull(elements.next(), "Null element"), null);
            tail.setNextPlain(next);
            tail = next;
        }
        return this.appendList(head, tail);
    }

    public boolean addAll(E[] items) {
        return this.addAll(items, 0, items.length);
    }

    public boolean addAll(E[] items, int off, int len) {
        LinkedNode head;
        Validate.notNull(items, "Items may not be null");
        Validate.arrayBounds(off, len, items.length, "Items array indices out of bounds");
        if (len == 0) {
            return false;
        }
        LinkedNode tail = head = new LinkedNode(Validate.notNull(items[off], "Null element"), null);
        for (int i = 1; i < len; ++i) {
            LinkedNode next = new LinkedNode(Validate.notNull(items[off + i], "Null element"), null);
            tail.setNextPlain(next);
            tail = next;
        }
        return this.appendList(head, tail);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Validate.notNull(collection, "Null collection");
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new LinkedIterator<E>(this.getHeadOpaque());
    }

    @Override
    public int size() {
        int size = 0;
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                ++size;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.peek() == null;
    }

    @Override
    public boolean contains(Object object) {
        Validate.notNull(object, "Null object");
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null && (element == object || element.equals(object))) {
                return true;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return false;
    }

    public E find(Predicate<E> predicate) {
        Validate.notNull(predicate, "Null predicate");
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null && predicate.test(element)) {
                return element;
            }
            if (next == null || next == curr) break;
            curr = next;
        }
        return null;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Validate.notNull(action, "Null action");
        LinkedNode<E> curr = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E element = curr.getElementPlain();
            if (element != null) {
                action.accept(element);
            }
            if (next == null || next == curr) break;
            curr = next;
        }
    }

    protected final boolean forceAppendList(LinkedNode<E> head, LinkedNode<E> tail) {
        LinkedNode<E> currTail;
        int failures = 0;
        LinkedNode<E> curr = currTail = this.getTailOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (next == null || next == curr) {
                LinkedNode<E> compared = curr.compareExchangeNextVolatile(next, head);
                if (compared == next) {
                    if (this.getTailOpaque() == currTail) {
                        this.setTailOpaque(tail);
                    }
                    return next != curr;
                }
                ++failures;
                curr = compared;
                continue;
            }
            if (curr == currTail) {
                curr = next;
                continue;
            }
            if (currTail == (currTail = this.getTailOpaque())) {
                curr = next;
                continue;
            }
            curr = currTail;
        }
    }

    protected final boolean appendList(LinkedNode<E> head, LinkedNode<E> tail) {
        LinkedNode currTail;
        int failures = 0;
        LinkedNode curr = currTail = this.getTailOpaque();
        LinkedNode<E> next;
        while ((next = curr.getNextVolatile()) != curr) {
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (next == null) {
                LinkedNode<E> compared = curr.compareExchangeNextVolatile(null, head);
                if (compared == null) {
                    if (this.getTailOpaque() == currTail) {
                        this.setTailOpaque(tail);
                    }
                    return true;
                }
                ++failures;
                curr = compared;
                continue;
            }
            if (curr == currTail) {
                curr = next;
                continue;
            }
            if (currTail == (currTail = this.getTailOpaque())) {
                curr = next;
                continue;
            }
            curr = currTail;
        }
        return false;
    }

    protected final E removeHead(Predicate<E> predicate) {
        LinkedNode<E> head;
        int failures = 0;
        LinkedNode<E> curr = head = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E currentVal = curr.getElementPlain();
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (currentVal != null) {
                if (!predicate.test(currentVal)) {
                    if (curr != head && this.getHeadOpaque() == head) {
                        this.setHeadOpaque(curr);
                    }
                    return null;
                }
                if (curr.getAndSetElementVolatile(null) == null) {
                    if (curr == (curr = next) || next == null) {
                        return null;
                    }
                    ++failures;
                    continue;
                }
                if (this.getHeadOpaque() == head) {
                    this.setHeadOpaque(next != null ? next : curr);
                }
                return currentVal;
            }
            if (curr == next || next == null) {
                if (curr != head && this.getHeadOpaque() == head) {
                    this.setHeadOpaque(curr);
                }
                return null;
            }
            if (head == curr) {
                curr = next;
                continue;
            }
            if (head == (head = this.getHeadOpaque())) {
                curr = next;
                continue;
            }
            curr = head;
        }
    }

    protected final E removeHead() {
        LinkedNode<E> head;
        int failures = 0;
        LinkedNode<E> curr = head = this.getHeadOpaque();
        while (true) {
            LinkedNode<E> next = curr.getNextVolatile();
            E currentVal = curr.getElementPlain();
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (currentVal != null) {
                if (curr.getAndSetElementVolatile(null) == null) {
                    if (curr == (curr = next) || next == null) {
                        return null;
                    }
                    ++failures;
                    continue;
                }
                if (this.getHeadOpaque() == head) {
                    this.setHeadOpaque(next != null ? next : curr);
                }
                return currentVal;
            }
            if (curr == next || next == null) {
                if (curr != head && this.getHeadOpaque() == head) {
                    this.setHeadOpaque(curr);
                }
                return null;
            }
            if (head == curr) {
                curr = next;
                continue;
            }
            if (head == (head = this.getHeadOpaque())) {
                curr = next;
                continue;
            }
            curr = head;
        }
    }

    public int drain(Consumer<E> consumer) {
        return this.drain(consumer, false, ConcurrentUtil::rethrow);
    }

    public int drain(Consumer<E> consumer, boolean preventAdds) {
        return this.drain(consumer, preventAdds, ConcurrentUtil::rethrow);
    }

    public int drain(Consumer<E> consumer, boolean preventAdds, Consumer<Throwable> exceptionHandler) {
        LinkedNode head;
        Validate.notNull(consumer, "Null consumer");
        Validate.notNull(exceptionHandler, "Null exception handler");
        int total = 0;
        LinkedNode curr = head = this.getHeadAcquire();
        while (true) {
            E currentVal = curr.getElementPlain();
            LinkedNode<E> next = curr.getNextVolatile();
            if (next == curr) break;
            if (currentVal == null) {
                if (next == null) {
                    if (!preventAdds || (next = curr.compareExchangeNextVolatile(null, curr)) == null) break;
                    curr = next;
                    continue;
                }
                curr = next;
                continue;
            }
            try {
                consumer.accept(currentVal);
            }
            catch (Exception ex) {
                this.setHeadOpaque(next != null ? next : curr);
                curr.setElementOpaque(null);
                exceptionHandler.accept(ex);
            }
            curr.setElementOpaque(null);
            ++total;
            if (next == null) {
                if (!preventAdds || (next = curr.compareExchangeNextVolatile(null, curr)) == null) break;
                curr = next;
                continue;
            }
            curr = next;
        }
        if (curr != head) {
            this.setHeadOpaque(curr);
        }
        return total;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 4368);
    }

    protected static final class LinkedNode<E> {
        protected volatile Object element;
        protected volatile LinkedNode<E> next;
        protected static final VarHandle ELEMENT_HANDLE = ConcurrentUtil.getVarHandle(LinkedNode.class, "element", Object.class);
        protected static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(LinkedNode.class, "next", LinkedNode.class);

        protected LinkedNode(Object element, LinkedNode<E> next) {
            ELEMENT_HANDLE.set(this, element);
            NEXT_HANDLE.set(this, next);
        }

        protected final E getElementPlain() {
            return (E)ELEMENT_HANDLE.get(this);
        }

        protected final E getElementVolatile() {
            return (E)ELEMENT_HANDLE.getVolatile(this);
        }

        protected final void setElementPlain(E update) {
            ELEMENT_HANDLE.set(this, update);
        }

        protected final void setElementOpaque(E update) {
            ELEMENT_HANDLE.setOpaque(this, update);
        }

        protected final void setElementVolatile(E update) {
            ELEMENT_HANDLE.setVolatile(this, update);
        }

        protected final E getAndSetElementVolatile(E update) {
            return (E)ELEMENT_HANDLE.getAndSet(this, update);
        }

        protected final E compareExchangeElementVolatile(E expect, E update) {
            return (E)ELEMENT_HANDLE.compareAndExchange(this, expect, update);
        }

        protected final LinkedNode<E> getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        protected final LinkedNode<E> getNextOpaque() {
            return NEXT_HANDLE.getOpaque(this);
        }

        protected final LinkedNode<E> getNextAcquire() {
            return NEXT_HANDLE.getAcquire(this);
        }

        protected final LinkedNode<E> getNextVolatile() {
            return NEXT_HANDLE.getVolatile(this);
        }

        protected final void setNextPlain(LinkedNode<E> next) {
            NEXT_HANDLE.set(this, next);
        }

        protected final void setNextVolatile(LinkedNode<E> next) {
            NEXT_HANDLE.setVolatile(this, next);
        }

        protected final LinkedNode<E> compareExchangeNextVolatile(LinkedNode<E> expect, LinkedNode<E> set) {
            return NEXT_HANDLE.compareAndExchange(this, expect, set);
        }
    }

    protected static final class LinkedIterator<E>
    implements Iterator<E> {
        protected LinkedNode<E> curr;
        protected LinkedNode<E> next;
        protected E nextElement;

        protected LinkedIterator(LinkedNode<E> start) {
            LinkedNode<E> curr = start;
            while (true) {
                LinkedNode<E> next = curr.getNextVolatile();
                E element = curr.getElementPlain();
                if (element != null) {
                    this.nextElement = element;
                    this.next = curr;
                    break;
                }
                if (next == null || next == curr) break;
                curr = next;
            }
        }

        protected final void findNext() {
            LinkedNode<E> next;
            LinkedNode<E> curr = this.next;
            while ((next = curr.getNextVolatile()) != null && next != curr) {
                E element = next.getElementPlain();
                if (element != null) {
                    this.nextElement = element;
                    this.curr = this.next;
                    this.next = next;
                    return;
                }
                curr = next;
            }
            this.next = null;
            this.nextElement = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E element = this.nextElement;
            if (element == null) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return element;
        }

        @Override
        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            this.curr.setElementVolatile(null);
            this.curr = null;
        }
    }
}

