/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.ansi;

import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.util.Services;
import net.kyori.ansi.ANSIComponentRenderer;
import net.kyori.ansi.ColorLevel;
import net.kyori.ansi.StyleOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class ANSIComponentSerializerImpl
implements ANSIComponentSerializer {
    private static final Optional<ANSIComponentSerializer.Provider> SERVICE = Services.service(ANSIComponentSerializer.Provider.class);
    static final Consumer<ANSIComponentSerializer.Builder> BUILDER = SERVICE.map(ANSIComponentSerializer.Provider::builder).orElseGet(() -> builder -> {});
    final ColorLevel colorLevel;
    final ComponentFlattener flattener;

    ANSIComponentSerializerImpl(ColorLevel colorLevel, ComponentFlattener flattener) {
        this.colorLevel = colorLevel;
        this.flattener = flattener;
    }

    @NotNull
    public String serialize(@NotNull Component component) {
        ANSIComponentRenderer.ToString renderer = ANSIComponentRenderer.toString((StyleOps)ComponentStyleOps.INSTANCE, (ColorLevel)this.colorLevel);
        this.flattener.flatten(component, (FlattenerListener)new ANSIFlattenerListener((ANSIComponentRenderer<Style>)renderer));
        renderer.complete();
        return renderer.asString();
    }

    static StyleOps.State mapState(TextDecoration.State state) {
        switch (state) {
            case NOT_SET: {
                return StyleOps.State.UNSET;
            }
            case FALSE: {
                return StyleOps.State.FALSE;
            }
            case TRUE: {
                return StyleOps.State.TRUE;
            }
        }
        throw new IllegalStateException("Decoration state is not valid");
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static class ComponentStyleOps
    implements StyleOps<Style> {
        static final ComponentStyleOps INSTANCE = new ComponentStyleOps();

        ComponentStyleOps() {
        }

        public StyleOps.State bold(@NotNull Style style) {
            return ANSIComponentSerializerImpl.mapState(style.decoration(TextDecoration.BOLD));
        }

        public StyleOps.State italics(@NotNull Style style) {
            return ANSIComponentSerializerImpl.mapState(style.decoration(TextDecoration.ITALIC));
        }

        public StyleOps.State underlined(@NotNull Style style) {
            return ANSIComponentSerializerImpl.mapState(style.decoration(TextDecoration.UNDERLINED));
        }

        public StyleOps.State strikethrough(@NotNull Style style) {
            return ANSIComponentSerializerImpl.mapState(style.decoration(TextDecoration.STRIKETHROUGH));
        }

        public StyleOps.State obfuscated(@NotNull Style style) {
            return ANSIComponentSerializerImpl.mapState(style.decoration(TextDecoration.OBFUSCATED));
        }

        public @Range(from=-1L, to=0xFFFFFFL) int color(@NotNull Style style) {
            TextColor color = style.color();
            return color == null ? -1 : color.value();
        }

        @Nullable
        public String font(@NotNull Style style) {
            Key font = style.font();
            return font == null ? null : font.asString();
        }
    }

    static class ANSIFlattenerListener
    implements FlattenerListener {
        private final ANSIComponentRenderer<Style> renderer;

        ANSIFlattenerListener(ANSIComponentRenderer<Style> renderer) {
            this.renderer = renderer;
        }

        public void pushStyle(@NotNull Style style) {
            this.renderer.pushStyle((Object)style);
        }

        public void component(@NotNull String text) {
            this.renderer.text(text);
        }

        public void popStyle(@NotNull Style style) {
            this.renderer.popStyle((Object)style);
        }
    }

    static final class BuilderImpl
    implements ANSIComponentSerializer.Builder {
        private ColorLevel colorLevel = ColorLevel.compute();
        private ComponentFlattener flattener = ComponentFlattener.basic();

        BuilderImpl() {
            BUILDER.accept(this);
        }

        @Override
        @NotNull
        public ANSIComponentSerializer.Builder colorLevel(@NotNull ColorLevel colorLevel) {
            this.colorLevel = colorLevel;
            return this;
        }

        @Override
        @NotNull
        public ANSIComponentSerializer.Builder flattener(@NotNull ComponentFlattener componentFlattener) {
            this.flattener = componentFlattener;
            return this;
        }

        @Override
        @NotNull
        public ANSIComponentSerializer build() {
            return new ANSIComponentSerializerImpl(this.colorLevel, this.flattener);
        }
    }

    static final class Instances {
        static final ANSIComponentSerializer INSTANCE = ANSIComponentSerializerImpl.access$000().map(ANSIComponentSerializer.Provider::ansi).orElseGet(() -> new ANSIComponentSerializerImpl(ColorLevel.compute(), ComponentFlattener.basic()));

        Instances() {
        }
    }
}

