/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.classes;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.rules.method.OwnableMethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import io.papermc.asm.util.OpcodeUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;

public class ClassToInterfaceRule
implements RewriteRule.Delegate {
    private final ClassDesc owner;
    private final @Nullable ClassDesc redirectExtension;
    private final RewriteRule rule;

    public ClassToInterfaceRule(ClassDesc owner, @Nullable ClassDesc redirectExtension) {
        this.owner = owner;
        this.redirectExtension = redirectExtension;
        this.rule = redirectExtension != null ? RewriteRule.chain(new ExtensionRewriter(redirectExtension), new MethodRewriter()) : new MethodRewriter();
    }

    @Override
    public RewriteRule delegate() {
        return this.rule;
    }

    final class ExtensionRewriter
    implements RewriteRule {
        private final ClassDesc replacement;

        ExtensionRewriter(ClassDesc replacement) {
            this.replacement = replacement;
        }

        @Override
        public ClassVisitor createVisitor(int api, ClassVisitor parent, ClassProcessingContext context) {
            return new ClassVisitor(api, parent){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (DescriptorUtils.toOwner(ClassToInterfaceRule.this.owner).equals(superName)) {
                        super.visit(version, access, name, signature, DescriptorUtils.toOwner(ExtensionRewriter.this.replacement), interfaces);
                    } else {
                        super.visit(version, access, name, signature, superName, interfaces);
                    }
                }
            };
        }
    }

    final class MethodRewriter
    implements OwnableMethodRewriteRule {
        MethodRewriter() {
        }

        @Override
        public Set<ClassDesc> owners() {
            return Set.of(ClassToInterfaceRule.this.owner);
        }

        @Override
        public  @Nullable MethodRewriteRule.Rewrite<?> rewrite(ClassProcessingContext context, boolean isInvokeDynamic, int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
            int newOpcode;
            if (OpcodeUtils.isStatic(opcode, isInvokeDynamic)) {
                return new MethodRewriteRule.RewriteSingle(opcode, owner, name, descriptor, true, isInvokeDynamic);
            }
            if (isInvokeDynamic && opcode == 5) {
                newOpcode = 9;
            } else if (!isInvokeDynamic && opcode == 182) {
                newOpcode = 185;
            } else {
                if (ClassToInterfaceRule.this.redirectExtension != null && opcode == 183 && "<init>".equals(name)) {
                    return new MethodRewriteRule.RewriteSingle(opcode, ClassToInterfaceRule.this.redirectExtension, name, descriptor, isInterface, isInvokeDynamic);
                }
                return null;
            }
            return new MethodRewriteRule.RewriteSingle(newOpcode, owner, name, descriptor, true, isInvokeDynamic);
        }
    }
}

