/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.generate.GeneratedMethodHolder;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.MethodNode;

public interface MethodRewriteRule
extends RewriteRule {
    public static final String LAMBDA_METAFACTORY_OWNER = "java/lang/invoke/LambdaMetafactory";

    default public boolean shouldProcess(ClassProcessingContext context, int opcode, String owner, String name, String descriptor, boolean isInterface) {
        return true;
    }

    @Override
    default public ClassVisitor createVisitor(int api, ClassVisitor parent, final ClassProcessingContext context) {
        final LinkedHashMap methodsToGenerate = new LinkedHashMap();
        return new ClassVisitor(api, parent){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                final MethodNode mn = new MethodNode(this.api, access, name, descriptor, signature, exceptions);
                return new MethodVisitor(this.api, (MethodVisitor)mn){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        MethodTypeDesc methodDesc;
                        ClassDesc methodOwner;
                        Rewrite<?> rewrite;
                        if (MethodRewriteRule.this.shouldProcess(context, opcode, owner, name, descriptor, isInterface) && (rewrite = MethodRewriteRule.this.rewrite(context, false, opcode, methodOwner = DescriptorUtils.fromOwner(owner), name, methodDesc = DescriptorUtils.methodDesc(descriptor), isInterface)) != null) {
                            rewrite.apply(this.getDelegate(), mn);
                            @Nullable MethodGenerator willGenerate = rewrite.createMethodGenerator();
                            if (willGenerate != null) {
                                record MethodKey(String owner, String name, MethodTypeDesc descriptor) {
                                }
                                methodsToGenerate.put(new MethodKey(owner, name, methodDesc), willGenerate);
                            }
                            return;
                        }
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }

                    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        Handle handle;
                        Object object;
                        if (MethodRewriteRule.LAMBDA_METAFACTORY_OWNER.equals(bootstrapMethodHandle.getOwner()) && bootstrapMethodArguments.length > 1 && (object = bootstrapMethodArguments[1]) instanceof Handle && MethodRewriteRule.this.shouldProcess(context, (handle = (Handle)object).getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface())) {
                            ClassDesc handleOwner = DescriptorUtils.fromOwner(handle.getOwner());
                            MethodTypeDesc handleDesc = DescriptorUtils.methodDesc(handle.getDesc());
                            @Nullable Rewrite<?> rewrite = MethodRewriteRule.this.rewrite(context, true, handle.getTag(), handleOwner, handle.getName(), handleDesc, handle.isInterface());
                            if (rewrite != null) {
                                rewrite.applyToBootstrapArguments(bootstrapMethodArguments);
                                @Nullable MethodGenerator willGenerate = rewrite.createMethodGenerator();
                                if (willGenerate != null) {
                                    methodsToGenerate.put(new MethodKey(handle.getOwner(), handle.getName(), handleDesc), willGenerate);
                                }
                            }
                        }
                        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    public void visitEnd() {
                        mn.accept(methodVisitor);
                        super.visitEnd();
                    }
                };
            }

            public void visitEnd() {
                RewriteRule.GeneratorAdapterFactory factory = (access, name, descriptor) -> {
                    MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, null, null);
                    return new GeneratorAdapter(methodVisitor, access, name, descriptor);
                };
                for (MethodGenerator consumer : methodsToGenerate.values()) {
                    consumer.generate(factory);
                }
                super.visitEnd();
            }
        };
    }

    public @Nullable Rewrite<?> rewrite(ClassProcessingContext var1, boolean var2, int var3, ClassDesc var4, String var5, MethodTypeDesc var6, boolean var7);

    public record RewriteSingle(int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface, boolean isInvokeDynamic, @Nullable GeneratorInfo<GeneratedMethodHolder.MethodCallData> generatorInfo, @Nullable Consumer<Object[]> handleExtras) implements Rewrite<GeneratedMethodHolder.MethodCallData>
    {
        public RewriteSingle(int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface, boolean isInvokeDynamic) {
            this(opcode, owner, name, descriptor, isInterface, isInvokeDynamic, null, null);
        }

        @Override
        public void apply(MethodVisitor delegate, MethodNode context) {
            delegate.visitMethodInsn(this.opcode(), DescriptorUtils.toOwner(this.owner()), this.name(), this.descriptor().descriptorString(), this.isInterface());
        }

        @Override
        public void applyToBootstrapArguments(Object[] arguments) {
            arguments[1] = new Handle(this.opcode(), DescriptorUtils.toOwner(this.owner()), this.name(), this.descriptor().descriptorString(), this.isInterface());
            if (this.handleExtras != null) {
                this.handleExtras.accept(arguments);
            }
        }

        @Override
        public Rewrite<GeneratedMethodHolder.MethodCallData> withNamePrefix(String prefix) {
            return new RewriteSingle(this.opcode(), this.owner(), prefix + this.name(), this.descriptor(), this.isInterface(), this.isInvokeDynamic(), this.generatorInfo(), this.handleExtras());
        }

        @Override
        public Rewrite<GeneratedMethodHolder.MethodCallData> withGeneratorInfo(GeneratedMethodHolder holder, GeneratedMethodHolder.MethodCallData original) {
            return new RewriteSingle(this.opcode(), this.owner(), this.name(), this.descriptor(), this.isInterface(), this.isInvokeDynamic(), new GeneratorInfo<GeneratedMethodHolder.MethodCallData>(holder, original), this.handleExtras());
        }

        @Override
        public Rewrite<GeneratedMethodHolder.MethodCallData> withHandleExtras(Consumer<Object[]> extras) {
            return new RewriteSingle(this.opcode(), this.owner(), this.name(), this.descriptor(), this.isInterface(), this.isInvokeDynamic(), this.generatorInfo(), extras);
        }

        @Override
        public @Nullable MethodGenerator createMethodGenerator() {
            if (this.generatorInfo == null) {
                return null;
            }
            GeneratedMethodHolder.MethodCallData original = this.generatorInfo.original();
            return factory -> this.generatorInfo.holder().generateMethod(factory, new GeneratedMethodHolder.MethodCallData(184, this.owner(), this.name(), this.descriptor(), this.isInvokeDynamic()), original);
        }
    }

    @FunctionalInterface
    public static interface MethodGenerator {
        public void generate(RewriteRule.GeneratorAdapterFactory var1);
    }

    public record GeneratorInfo<D extends GeneratedMethodHolder.CallData>(GeneratedMethodHolder holder, D original) {
    }

    public static interface Rewrite<D extends GeneratedMethodHolder.CallData> {
        public static final int BOOTSTRAP_HANDLE_IDX = 1;
        public static final int DYNAMIC_TYPE_IDX = 2;

        public void apply(MethodVisitor var1, MethodNode var2);

        public void applyToBootstrapArguments(Object[] var1);

        public Rewrite<D> withGeneratorInfo(GeneratedMethodHolder var1, D var2);

        public Rewrite<D> withNamePrefix(String var1);

        default public Rewrite<D> withHandleExtras(Consumer<Object[]> extras) {
            return this;
        }

        public @Nullable MethodGenerator createMethodGenerator();
    }
}

